#!/bin/bash

# --- 1. 基本情報の自動取得 ---
USER_NAME=$(whoami)
USER_HOME=$HOME
TARGET_DIR="$USER_HOME/monitor"

echo "Setup starting for user: $USER_NAME at $TARGET_DIR"
sudo apt update

#<< samba
sudo apt install samba -y
echo "
[rasp_pi]
    comment = Share
    path = $USER_HOME
    public = yes
    read only = no
    browsable = yes
    force user = $USER_NAME
" | sudo tee -a  /etc/samba/smb.conf
sudo systemctl restart smbd
sudo systemctl enable smbd
#samba

# フォルダ作成と移動
mkdir -p "$TARGET_DIR"
cd "$TARGET_DIR"

# --- 2. SSL証明書 (mkcert) ---
sudo apt install -y libnss3-tools
wget -O mkcert https://github.com/FiloSottile/mkcert/releases/download/v1.4.1/mkcert-v1.4.1-linux-arm
chmod +x mkcert
sudo mv mkcert /usr/local/bin/
mkcert -install
mkcert localhost

# --- 3. UV4Lインストール (stretch固定) ---
curl https://www.linux-projects.org/listing/uv4l_repo/lpkey.asc | sudo gpg --dearmor -o /usr/share/keyrings/uv4l-archive-keyring.gpg
echo "deb [signed-by=/usr/share/keyrings/uv4l-archive-keyring.gpg] https://www.linux-projects.org/listing/uv4l_repo/raspbian/stretch stretch main" | sudo tee /etc/apt/sources.list.d/uv4l.list 
sudo apt update
sudo apt install uv4l uv4l-webrtc uv4l-uvc -y

# --- 4. UV4L設定ファイル (雛形) ---
echo "
device-id = xxxx:xxxx
server-option = --use-ssl=yes 
server-option = --ssl-private-key-file=$TARGET_DIR/localhost-key.pem 
server-option = --ssl-certificate-file=$TARGET_DIR/localhost.pem
" | sudo tee -a /etc/uv4l/uv4l-uvc.conf

# --- 5. オーディオ仮設定 
echo "pcm.!default {
    type asym
    playback.pcm \"plug:hw:xxx\"
    capture.pcm \"plug:dsnoop:yyy\"
}" | sudo tee /etc/asound.conf

# --- 6. 周辺機能 (PiGPIO) ---
sudo apt install -y pigpio
sudo systemctl enable pigpiod
sudo systemctl start pigpiod

# --- 7. Python仮想環境 ---
python3 -m venv venv
. venv/bin/activate
pip install --upgrade pip
pip install websockets gpiozero pigpio

echo "-------------------------------------------------------"
echo "  セットアップが完了しました！"
echo "-------------------------------------------------------"
echo "【重要：最後に必ず行うこと】"
echo "1. 'lsusb' を実行して、あなたのWebカメラのIDを確認してください。"
echo "   'sudo nano /etc/uv4l/uv4l-uvc.conf' を開き、device-id を書き換えてください。"
echo "2. 'arecord -l'を実行して、オーディオを確認して下さい。"
echo "   'sudo nano /etc/asound.conf'を開き、システムに合わせて修正して下さい"
echo "3. IP Addressの固定を奨めます。下記のxxx.xxx.xxx.xxxにIPを指定して下さい"
echo "   sudo nmcli connection modify preconfigured ipv4.method manual ipv4.addresses xxx.xxx.xxx.xxx/24" 
echo "4. 設定終了後 reboot して下さい。"
echo "-------------------------------------------------------"


