let ws = null;
let pc;
let audio_video_stream;
let recorder = null;
let aa_streams = [];
let mediaConstraints = {
    optional: [{echoCancellation: true}],
    mandatory: {
        OfferToReceiveAudio: true,
        OfferToReceiveVideo: true
    }
};
let iceCandidates = [];
let remoteVideo = document.getElementById("remote-video");
let recordedBlobs = [];
let stream = 0;
let light_ = 0;
let photo_rec = 0;

/*
stream
        0: Stop
        1: Start
light_ 
        0: off
        1: on
photo_rec
        0: none
        1: download
        2: rec 
        3: play
*/

light_on_off(0);

let socket;
let posInterval = null;
let btn_touch = 0;

function connectWSS() {
    socket = new WebSocket('wss://' + window.location.hostname + ':8700');

    socket.onmessage = (event) => {
        const positionData = JSON.parse(event.data);
        document.getElementById('status-display').innerText = "● " + positionData;
    };

    socket.onclose = () => setTimeout(connectWSS, 2000);
}

const container = document.getElementById('btn_grp');
container.addEventListener('pointerdown', (e) => {
    const btn = e.target.closest('.btn-rect');
    if (btn && !btn.disabled) {
        btn_touch = 1;
        send_to_serv(btn.id); // 'up', 'down' などの移動開始

        if (!posInterval) {
            posInterval = setInterval(() => {
                send_to_serv('get_pos');
            }, 300);
        }
    }
});

window.addEventListener('pointerup', () => {
    if (btn_touch) {
        btn_touch = 0;
        send_to_serv('stop'); // 移動停止
        
        clearInterval(posInterval);
        posInterval = null;
    }
});

window.addEventListener('load', () => {
    // 1. PCマイクを0に設定（ミュート）
    adjustVolume('me', 0);

    // 2. PIスピーカーを50に設定
    // ※WebSocketがつながる前に送るとエラーになるため、少し待つか
    // もしくは connectWebSocket の onopen 内で実行するのが確実です
    setTimeout(() => {
        adjustVolume('other', 70);
    }, 1000); 
});

// 起動
connectWSS();

function updateStatus(message) {
    let color,str;

    console.log("Action Executed: " + message);

    switch (message) {
        case "start":   // Streaming Start / Stop
                        stream = stream ^ 1;
                        if(stream){
                            str = "Stream Stop";
                            color = "#e94560";
                            start();
                        }
                        else{
                            str = "Stream Start";
                            color = "#00b894";
                            stop();
                        }
                        document.getElementById('start').innerHTML = str; 
                        document.getElementById('start').style.backgroundColor = color;                         
                        break;

        case "light":   // Light on / off 
                        light_on_off(1);
                        break;

        case "photo":   // photo
                        if(photo_rec){
                            photo_rec = 0;

                            document.getElementById('play-video').style.display = "none";
                            remoteVideo.style.display = "inline";
                            remoteVideo.play();
                            remoteVideo.muted = false;

                            document.getElementById('start').disabled = false;
                            document.getElementById('start').style.backgroundColor = "#e94560";                         
                            document.getElementById('photo').innerHTML = 'Photo'; 
                            document.getElementById('rec').innerHTML = 'Record'; 
                            set_button(2,false);
                        }
                        else{
                            document.getElementById('start').disabled = true;
                            document.getElementById('start').style.backgroundColor = "#4b5563";                         
                            take_photo();
                            photo_rec = 1;
                        }
                        break;
                                    
        case "rec":   // rec
                        switch(photo_rec){
                            case 0:
                                    document.getElementById('start').disabled = true;
                                    document.getElementById('start').style.backgroundColor = "#4b5563";                         
                                    set_button(2,true);
                                    photo_rec = 2;
                                    rec_video();
                                    break;
                            case 1:
                                    dn_photo();
                                    break;

                            case 2:
                                    photo_rec = 3;
                                    stop_rec();
                                    break;
                            case 3:
                                    photo_rec = 3;
                                    play_video();
                                    break;
                        }
                        break;
                                    
    }
}

let audioContext;
let gainNode;
let microphoneSource;

async function adjustVolume(target, value) {
    const volume = value / 100; // 0.0 ～ 1.0 の範囲

    if (target === 'me') {
        // --- PCマイク (送信側) のゲイン調整 ---
        if (gainNode) {
            // gainNodeの値を変更することで、送信される音の振幅を変えます
            gainNode.gain.setValueAtTime(volume / 5, audioContext.currentTime);
            console.log("Mic Gain adjusted to: " + value + "%");
        }
        
        // 0の時はトラック自体を止めて完全にミュートにする
        if (audio_video_stream) {
            const tracks = audio_video_stream.getAudioTracks();
            if (tracks.length > 0) {
                tracks[0].enabled = (value > 0);
            }
        }
    } 
    else if (target === 'other') {
        // ... (既存のPIスピーカー処理はそのまま) ...
        if (remoteVideo) remoteVideo.volume = volume;
        if (socket && socket.readyState === WebSocket.OPEN) {
            socket.send(JSON.stringify({ cmd: 'set_vol', value: value }));
        }
    }
}
function light_on_off(flg){
    let color,str;

    if(flg){
        light_ = light_ ^ 1;
        send_to_serv('light', light_);
    }

    str = "Light Off";
    color = "#00b894";
    if(light_){
        str = "Light On"; 
        color = "#e94560";
    } 
    document.getElementById('light').innerHTML = str;    
    document.getElementById('light').style.backgroundColor = color;                         
}                   

function send_to_serv(cmd, _data = "1") {
    if (socket && socket.readyState === WebSocket.OPEN) {
        const msg = JSON.stringify({ "cmd": cmd, "value": _data });
        socket.send(msg);
    } else {
        console.error("WebSocketが接続されていません。状態: " + (socket ? socket.readyState : "未初期化"));
    }
}

function set_button(_st, flg){
    let disp_buf = ['rec', 'photo', 'up', 'left', 'right', 'down'];
    let color;

    color = "#00b894";
    if(flg)
        color = "#4b5563";
    disp_buf.slice(_st).forEach(element => {
            document.getElementById(element).disabled = flg;
            if(!flg && _st > 1)
                color = "#1a1a2e";
            document.getElementById(element).style.backgroundColor = color;
            _st ++;
        }
    );
}

function createPeerConnection() {
    try {
        pc = new RTCPeerConnection();
        pc.onicecandidate = onIceCandidate;
        pc.ontrack = onTrack;
        pc.onremovestream = onRemoteStreamRemoved;
        console.log("peer connection successfully created!");
    } 
    catch (e) {
        console.error("createPeerConnection() failed");
    }
}

function onIceCandidate(event) {
    if (event.candidate && event.candidate.candidate) {
        let candidate = {
            sdpMLineIndex: event.candidate.sdpMLineIndex,
            sdpMid: event.candidate.sdpMid,
            candidate: event.candidate.candidate
        };
        let request = {
            what: "addIceCandidate",
            data: JSON.stringify(candidate)
        };
        ws.send(JSON.stringify(request));
    } 
    else {
        console.log("End of candidates.");
    }
}

function addIceCandidates() {
    iceCandidates.forEach(function (candidate) {
        pc.addIceCandidate(candidate,
            function () {
            //    console.log("IceCandidate added: " + JSON.stringify(candidate));
                console.log("IceCandidate added: ");
            },
            function (error) {
                console.error("addIceCandidate error: " + error);
            }
        );
    });
    iceCandidates = [];
}

function onTrack(event) {
    console.log("Remote track!");
    let remoteVideoElement = document.getElementById('remote-video');
    remoteVideoElement.srcObject = event.streams[0];
    aa_streams[0] = event.streams[0];
}

function onRemoteStreamRemoved(event) {
    let remoteVideoElement = document.getElementById('remote-video');
    remoteVideoElement.srcObject = null;
}

async function start() {
// 既存の接続があれば強制的に閉じる
    if (ws || pc) {
        console.log("Cleaning up previous connection...");
        stop(); 
        await new Promise(resolve => setTimeout(resolve, 500)); // 0.5秒待機
    }    
    document.getElementById('status-display').innerText = "● Connecting";
    if ("WebSocket" in window) {
        let protocol = location.protocol === "https:" ? "wss:" : "ws:";
        ws = new WebSocket(protocol + '//' + window.location.hostname + ':8090/stream/webrtc');
        ws.onopen = async function () {
            iceCandidates = [];
            remoteDesc = false;

            const audioConstraints = {
                video: false,
                audio: {
                    echoCancellation: true,      // エコーキャンセレーション
                    noiseSuppression: true,     // ノイズ抑制
                    autoGainControl: true, // これを true にすると自動で音量を抑えてくれます
                    sampleRate: 44100      // サンプリングレートを固定して安定させる            
                    }
            };

            audio_video_stream = await navigator.mediaDevices.getUserMedia(audioConstraints);

            // --- Web Audio API のセットアップ ---
            audioContext = new (window.AudioContext || window.webkitAudioContext)();
            microphoneSource = audioContext.createMediaStreamSource(audio_video_stream);
            gainNode = audioContext.createGain();
    
            // スライダーの現在の値を初期値として適用
            const initialVol = document.getElementById('vol_me').value / 100;
            gainNode.gain.setValueAtTime(initialVol, audioContext.currentTime);

            // マイク音源 -> ゲイン調整(GainNode) -> 出力先(Destination)
            const destination = audioContext.createMediaStreamDestination();
            microphoneSource.connect(gainNode);
            gainNode.connect(destination);

            createPeerConnection();
            
            // 重要：元の audio_video_stream ではなく、加工後の音声トラックを pc に追加する
            const processedStream = destination.stream;
            audio_video_stream.getVideoTracks().forEach(track => pc.addTrack(track, audio_video_stream));
            processedStream.getAudioTracks().forEach(track => pc.addTrack(track, processedStream));
    
            let request = { what: "call", options: { force_hw_vcodec: false, vformat: "30", trickle_ice: true } };
            ws.send(JSON.stringify(request));
            //    console.log("call(), request=" + JSON.stringify(request));
        };

        ws.onmessage = async function (evt) {
            let what,data;
            let msg = JSON.parse(evt.data);
            if (msg.what !== 'undefined') {
                what = msg.what;
                data = msg.data;
            }
        //    console.log("message =" + what);

            switch (what) {
                case "offer":   //"offer"の処理
                    pc.setRemoteDescription(new RTCSessionDescription(JSON.parse(data)), 
                        function onRemoteSdpSuccess() {     
                            remoteDesc = true;
                            addIceCandidates();                             //IceCandidateを追加する関数
//                            console.log('onRemoteSdpSucces()');
                            pc.createAnswer(function (sessionDescription) { //createAnswerの製作
                                pc.setLocalDescription(sessionDescription);    //ICE candidate の収集が開始
                                    let request = {
                                        what: "answer",
                                        data: JSON.stringify(sessionDescription)
                                    };
                                    ws.send(JSON.stringify(request));
//                                    console.log(request);

                                }, function (error) {
                                    alert("Failed to createAnswer: " + error);

                                }, mediaConstraints);
                            },
                            function onRemoteSdpError(event) {  
                                alert('Failed to set remote description (unsupported codec on this browser?): ' + event);
                                stop();
                            }
                    );
                    break;

                case "iceCandidate": // when trickle is enabled
                    if (!msg.data) {
                        console.log("Ice Gathering Complete");
                        break;
                    }
                    let elt = JSON.parse(msg.data);
                    let candidate = new RTCIceCandidate({sdpMLineIndex: elt.sdpMLineIndex, candidate: elt.candidate});
                    iceCandidates.push(candidate);
                    if (remoteDesc)
                        addIceCandidates();
                    document.documentElement.style.cursor = 'default';
                    break;
            }
        };

        ws.onclose = function (evt) {
            if (pc) {
                pc.close();
                pc = null;
            }
            document.documentElement.style.cursor = 'default';
        };

        ws.onerror = function (evt) {
            alert("An error has occurred!");
            ws.close();
        };

    } 
    else {
        alert("Sorry, this browser does not support WebSockets.");
    }
    set_button(0, false);
}

function stop() {
    console.log("Stopping and Cleaning...");
    
    // 1. WebSocketを確実に閉じる
    if (ws) {
        ws.onmessage = null;
        ws.onclose = null;
        ws.close();
        ws = null;
    }

    // 2. PeerConnectionを確実に閉じる
    if (pc) {
        pc.getSenders().forEach(sender => pc.removeTrack(sender));
        pc.close();
        pc = null;
    }

    // 3. カメラとマイクのハードウェアを解放する（最重要！）
    if (audio_video_stream) {
        audio_video_stream.getTracks().forEach(track => {
            track.stop();
            console.log("Hardware track stopped: " + track.kind);
        });
        audio_video_stream = null;
    }

    const remoteVideo = document.getElementById('remote-video');
    if (remoteVideo) remoteVideo.srcObject = null;

    set_button(0, true);
    document.getElementById('status-display').innerText = "● SYSTEM READY";
}

function rec_video() {
    document.getElementById('photo').innerHTML = 'Back'; 
    document.getElementById('rec').innerHTML = 'Stop'; 

    recordedBlobs = [];
    var options = {mimeType: 'video/webm;codecs=vp9,opus'};
    if (!MediaRecorder.isTypeSupported(options.mimeType)) {
        console.log(options.mimeType + ' is not Supported');
        //options = {mimeType: 'video/webm;codecs=vp8'};
        options = {mimeType: 'video/webm;codecs=vp8,opus'};
        if (!MediaRecorder.isTypeSupported(options.mimeType)) {
            console.log(options.mimeType + ' is not Supported');
            options = {mimeType: 'video/webm;codecs=h264'};
            if (!MediaRecorder.isTypeSupported(options.mimeType)) {
                console.log(options.mimeType + ' is not Supported');
                options = {mimeType: 'video/webm'};
                if (!MediaRecorder.isTypeSupported(options.mimeType)) {
                    console.log(options.mimeType + ' is not Supported');
                    options = {mimeType: ''};
                }
            }
        }
    }

    try {
        recorder = new MediaRecorder(aa_streams[0], options);
    } 
    catch (e) {
        console.error('Exception while creating MediaRecorder: ' + e);
        alert('Exception while creating MediaRecorder: ' + e + '. mimeType: ' + options.mimeType);
        return;
    }
    console.log('Created MediaRecorder', recorder, 'with options', options);
    recorder.ondataavailable = handleDataAvailable;
    recorder.onwarning = function (e) {
        console.log('Warning: ' + e);
    };
    recorder.start();
    console.log('MediaRecorder started', recorder);
 }

function stop_rec() {
    document.getElementById('rec').innerHTML = 'Play Video'; 
    if (recorder) {
        recorder.stop();
        console.log("recording stopped");
//        document.getElementById('record').innerHTML = 'Video';
        recorder = null;
    }
}

function handleDataAvailable(event) {
    if (event.data && event.data.size > 0) {
        recordedBlobs.push(event.data);
    }
}

function play_video() {
    console.log('Play video');
    remoteVideo.style.display = "none";
    remoteVideo.pause();
    remoteVideo.muted = true;
    document.getElementById('play-video').style.display = "inline";

    let superBuffer = new Blob(recordedBlobs, {type: 'video/webm'});
    let recordedVideoElement = document.getElementById('play-video');

    if (recordedVideoElement.src) {
        URL.revokeObjectURL(recordedVideoElement.src);
    }

    recordedVideoElement.src = URL.createObjectURL(superBuffer);
    recordedVideoElement.controls = true;
    recordedVideoElement.load();
}

function get_time() {
    let now = new Date();
    let mt = now.getMonth() + 1;
    now = now.getFullYear() + '-' + mt + '-' + now.getDate() + '_'
         + now.getHours() + '-' + now.getMinutes() + '-' + now.getSeconds();
    console.log(now);
    return now;
}

function dn_photo(){
    let canvas = document.querySelector('canvas');
    let url = canvas.toDataURL('image/jpeg', 1.0);
    let a = document.createElement('a');
    a.style.display = 'none';
    a.href = url;
    a.download = get_time() + ".jpg";
    document.body.appendChild(a);
    a.click();
    setTimeout(function () {
        document.body.removeChild(a);
        }, 100
    );
}

function take_photo() {
    set_button(2,true);
    document.getElementById('photo').innerHTML = 'Back'; 
    document.getElementById('rec').innerHTML = 'Down Load'; 
    remoteVideo.pause();
    let canvas = document.querySelector('canvas');
    canvas.width = remoteVideo.videoWidth;
    canvas.height = remoteVideo.videoHeight;
    canvas.getContext('2d').drawImage(remoteVideo, 0, 0, canvas.width, canvas.height);
}

