let ws = null;
let pc;
let audio_video_stream;
let recorder = null;
let aa_streams = [];
let mediaConstraints = {
    optional: [{echoCancellation: true}],
    mandatory: {
        OfferToReceiveAudio: true,
        OfferToReceiveVideo: true
    }
};
let iceCandidates = [];
let remoteVideo = document.getElementById("remote-video");
let recordedBlobs = [];
let disp_buf = ['photo', 'record', 'stp_rec', 'pt_dn', 'play_v', 'back'];

start();

function createPeerConnection() {
    try {
        pc = new RTCPeerConnection();
        pc.onicecandidate = onIceCandidate;
        pc.ontrack = onTrack;
        pc.onremovestream = onRemoteStreamRemoved;
        console.log("peer connection successfully created!");
    } 
    catch (e) {
        console.error("createPeerConnection() failed");
    }
}

function onIceCandidate(event) {
    if (event.candidate && event.candidate.candidate) {
        var candidate = {
            sdpMLineIndex: event.candidate.sdpMLineIndex,
            sdpMid: event.candidate.sdpMid,
            candidate: event.candidate.candidate
        };
        var request = {
            what: "addIceCandidate",
            data: JSON.stringify(candidate)
        };
        ws.send(JSON.stringify(request));
    } 
    else {
        console.log("End of candidates.");
    }
}

function addIceCandidates() {
    iceCandidates.forEach(function (candidate) {
        pc.addIceCandidate(candidate,
            function () {
                console.log("IceCandidate added: " + JSON.stringify(candidate));
            },
            function (error) {
                console.error("addIceCandidate error: " + error);
            }
        );
    });
    iceCandidates = [];
}

function onTrack(event) {
    console.log("Remote track!");
    var remoteVideoElement = document.getElementById('remote-video');
    remoteVideoElement.srcObject = event.streams[0];
    aa_streams[0] = event.streams[0];
}

function onRemoteStreamRemoved(event) {
    var remoteVideoElement = document.getElementById('remote-video');
    remoteVideoElement.srcObject = null;
    remoteVideoElement.src = ''; // TODO: remove
}

async function start() {
    if ("WebSocket" in window) {
        var protocol = location.protocol === "https:" ? "wss:" : "ws:";
        ws = new WebSocket(protocol + '//192.168.1.200:8090/stream/webrtc');
        ws.onopen = async function () {
            iceCandidates = [];
            remoteDesc = false;
            audio_video_stream = await navigator.mediaDevices.getUserMedia({video: false, audio: true});
            createPeerConnection();
            audio_video_stream.getTracks().forEach(track => pc.addTrack(track, audio_video_stream));
            var request = {
                what: "call",
                options: {
                    force_hw_vcodec: false,
                    vformat: "30",
                    trickle_ice: true
                }
            };
            ws.send(JSON.stringify(request));
            console.log("call(), request=" + JSON.stringify(request));
        };

        ws.onmessage = function (evt) {
            var msg = JSON.parse(evt.data);
            if (msg.what !== 'undefined') {
                var what = msg.what;
                var data = msg.data;
            }
            console.log("message =" + what);

            switch (what) {
                case "offer":
                    pc.setRemoteDescription(new RTCSessionDescription(JSON.parse(data)),
                        function onRemoteSdpSuccess() {
                            remoteDesc = true;
                            addIceCandidates();
                            console.log('onRemoteSdpSucces()');
                            pc.createAnswer(function (sessionDescription) {
                                pc.setLocalDescription(sessionDescription);
                                    var request = {
                                        what: "answer",
                                        data: JSON.stringify(sessionDescription)
                                    };
                                    ws.send(JSON.stringify(request));
                                    console.log(request);

                                }, function (error) {
                                    alert("Failed to createAnswer: " + error);

                                }, mediaConstraints);
                            },
                            function onRemoteSdpError(event) {
                                alert('Failed to set remote description (unsupported codec on this browser?): ' + event);
                                stop();
                            }
                    );
                    break;

                case "iceCandidate": // when trickle is enabled
                    if (!msg.data) {
                        console.log("Ice Gathering Complete");
                        break;
                    }
                    var elt = JSON.parse(msg.data);
                    let candidate = new RTCIceCandidate({sdpMLineIndex: elt.sdpMLineIndex, candidate: elt.candidate});
                    iceCandidates.push(candidate);
                    if (remoteDesc)
                        addIceCandidates();
                    document.documentElement.style.cursor = 'default';
                    break;
            }
        };

        ws.onclose = function (evt) {
            if (pc) {
                pc.close();
                pc = null;
            }
            document.documentElement.style.cursor = 'default';
        };

        ws.onerror = function (evt) {
            alert("An error has occurred!");
            ws.close();
        };

    } 
    else {
        alert("Sorry, this browser does not support WebSockets.");
    }
}

function mute_other() {
    remoteVideo.muted = !remoteVideo.muted;
    if (remoteVideo.muted){
        document.getElementById("mute_other").style.backgroundColor = 'red';
    }
    else{
        document.getElementById("mute_other").style.backgroundColor = '#228b22';
    }
}

function mute_me() {
    audio_video_stream.getAudioTracks()[0].enabled = !audio_video_stream.getAudioTracks()[0].enabled;
    if (audio_video_stream.getAudioTracks()[0].enabled){
        document.getElementById('mute_me').style.backgroundColor = '#228b22';
    }
    else{
        document.getElementById("mute_me").style.backgroundColor = 'red';
    }
}

function rec_video() {
    let buf = [0, 0, 1, 0, 0, 0];
    set_disp(buf);

    recordedBlobs = [];
    var options = {mimeType: 'video/webm;codecs=vp9,opus'};
    if (!MediaRecorder.isTypeSupported(options.mimeType)) {
        console.log(options.mimeType + ' is not Supported');
        //options = {mimeType: 'video/webm;codecs=vp8'};
        options = {mimeType: 'video/webm;codecs=vp8,opus'};
        if (!MediaRecorder.isTypeSupported(options.mimeType)) {
            console.log(options.mimeType + ' is not Supported');
            options = {mimeType: 'video/webm;codecs=h264'};
            if (!MediaRecorder.isTypeSupported(options.mimeType)) {
                console.log(options.mimeType + ' is not Supported');
                options = {mimeType: 'video/webm'};
                if (!MediaRecorder.isTypeSupported(options.mimeType)) {
                    console.log(options.mimeType + ' is not Supported');
                    options = {mimeType: ''};
                }
            }
        }
    }

    try {
        recorder = new MediaRecorder(aa_streams[0], options);
    } 
    catch (e) {
        console.error('Exception while creating MediaRecorder: ' + e);
        alert('Exception while creating MediaRecorder: ' + e + '. mimeType: ' + options.mimeType);
        return;
    }
    console.log('Created MediaRecorder', recorder, 'with options', options);
    recorder.ondataavailable = handleDataAvailable;
    recorder.onwarning = function (e) {
        console.log('Warning: ' + e);
    };
    recorder.start();
    console.log('MediaRecorder started', recorder);
 }

function stop_rec() {
    let buf = [0, 0, 0, 0, 1, 1];
    set_disp(buf);
    if (recorder) {
        recorder.stop();
        console.log("recording stopped");
        document.getElementById('record').innerHTML = 'Video';
        recorder = null;
    }
}

function handleDataAvailable(event) {
    //console.log(event);
    if (event.data && event.data.size > 0) {
        recordedBlobs.push(event.data);
    }
}

function play_video() {
    console.log('Play video');
    let buf = [0, 0, 0, 0, 0, 1];
    set_disp(buf);
    remoteVideo.style.display = "none";
    remoteVideo.pause();
    remoteVideo.muted = true;
    document.getElementById('play-video').style.display = "inline";

    var superBuffer = new Blob(recordedBlobs, {type: 'video/webm'});
    var recordedVideoElement = document.getElementById('play-video');
    recordedVideoElement.src = URL.createObjectURL(superBuffer);
}

function dn_photo(){
    var canvas = document.querySelector('canvas');
    var url = canvas.toDataURL('image/jpeg', 1.0);
    var a = document.createElement('a');
    a.style.display = 'none';
    a.href = url;
    a.download = get_time() + ".jpg";
    document.body.appendChild(a);
    a.click();
    setTimeout(function () {
    document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
    }, 100);
}

function take_photo() {
    let buf = [0, 0, 0, 1, 0, 1];
    set_disp(buf);
 
    remoteVideo.pause();
    var canvas = document.querySelector('canvas');
    canvas.width = remoteVideo.videoWidth;
    canvas.height = remoteVideo.videoHeight;
    canvas.getContext('2d').drawImage(remoteVideo, 0, 0, canvas.width, canvas.height);
}

function set_disp(buf){
    let a= 0;
    let str;

    disp_buf.forEach(element => {
            str = 'none';
            if(buf[a] == 1) str = 'inline';
            document.getElementById(element).style.display = str;
            a ++;
        }
    );
}

function _back() {
    let buf = [1, 1, 0, 0, 0, 0];
    set_disp(buf);
    document.getElementById('play-video').style.display = "none";
    remoteVideo.style.display = "inline";
    remoteVideo.play();
    remoteVideo.muted = false;
}

function get_time() {
    var now = new Date();
    var mt = now.getMonth();
    mt += 1;
    now = now.getFullYear() + '-' + mt + '-' + now.getDate() + '_'
         + now.getHours() + '-' + now.getMinutes() + '-' + now.getSeconds();
    console.log(now);
    return now;
}
