from http.server import HTTPServer, SimpleHTTPRequestHandler
import ssl

class MyHandler(SimpleHTTPRequestHandler):
    def do_GET(self):
        self.send_response(200)

        if self.path == "/":
            self.path = "/intercom.html"
            dataType = "text/html"

        elif self.path.endswith(".css"):
            dataType = "text/css"
     
        elif self.path.endswith(".js"):
            dataType = "application/javascript"

        elif self.path.endswith(".ico"):
            dataType = "text/plain"

        self.path = "." + self.path
        f = open(self.path,'rb')
        self.send_header('Content-type', dataType)
        self.end_headers()
        self.wfile.write(f.read())
        f.close()

host = ''
port = 443
httpd = HTTPServer((host, port), MyHandler)
context = ssl.SSLContext(ssl.PROTOCOL_TLS_SERVER)
context.load_cert_chain(certfile='./localhost.pem', keyfile='./localhost-key.pem')
httpd.socket = context.wrap_socket(httpd.socket, server_side=True)
print("HTTPS Server running on https://X.X.X.X>:443")
httpd.serve_forever()



