from http.server import HTTPServer, SimpleHTTPRequestHandler
from urllib.parse import urlparse,parse_qs
import subprocess
from subprocess import PIPE
import os

flg_state = 0
proc_pt = subprocess.Popen("./st_mjpg.sh",shell=True)

class MyHandler(SimpleHTTPRequestHandler):

    def do_GET(self):
        global flg_state, proc_pt
            
        self.send_response(200)

        fl = 1
        if self.chk_file() == 0:
            parsed = urlparse(self.path)
            params = parse_qs(parsed.query)
            a = next(iter(params))

            #-----  Stream Command -----------------
            if a == "1":
                cmd = params['1'][0]

                #-----  flg_state   -----------
                # 0: Stream
                # 1: start/Stop rec
                # 2: take photo
                # 3: Replay video 

                #-----  Start Streaming -----------  
                if cmd == '_start':
                    flg_state = 0

                #-----  Rec -----------  
                elif cmd == '_rec':
                    if flg_state != 1:
                        subprocess.run("rm file.mp4".split())
                        cmd = "ffmpeg -i http://rasp.local:8080/?action=stream -an -r 10 -vcodec libx264 ./file.mp4"
                        proc_pt = subprocess.Popen(cmd, shell=True)
                        flg_state = 1
                    else :
                        proc_pt.kill()
                        cmd = "killall -s INT ffmpeg"
                        proc = subprocess.run(cmd.split())
                        flg_state = 0

                #-----  take picture -----------  
                elif cmd == '_photo':
                    flg_state = 2
                    cmd = "wget -O ./phto.jpg http://rasp.local:8080/?action=snapshot"
                    proc = subprocess.run(cmd.split())

                #-----  show picture -----------  
                elif cmd == '_rephoto':
                    flg_state = 2

                #-----  Relay -----------  
                elif cmd == '_replay':
                    flg_state = 3

            #-----  Data transfer  --------------
            elif a == "80":
                self.send_header('Content-type', "text/plain")
                self.end_headers()

                a = 0
                if os.path.exists("./phto.jpg") == True :
                    a = 1
                if os.path.exists("./file.mp4") == True :
                    a += 2

                buf = str(flg_state) + ',' + str(a) + ','
                self.wfile.write(buf.encode())

                fl = 0

       #-------------------------------------
        else :
            fl = 0

        if fl == 1:
            f = open("./stream.html",'rb')
            self.send_header('Content-type', "text/html")
            self.end_headers()
            self.wfile.write(f.read())
            f.close()

    #-------------------------------------------------
    def chk_file(self):
        global flg_state

        a = 0
        if self.path == "/":
            self.path = "/stream.html"
            dataType = "text/html"
            flg_state = 0
            a = 1
        if self.path.endswith(".css"):
            dataType = "text/css"
            a = 1
     
        if self.path.endswith(".jpg"):
            dataType = "image/jpeg"
            a = 1
   
        if self.path.endswith(".ico"):
            dataType = "text/plain"
            a = 1

        if self.path.endswith(".mp4"):
            dataType = "video/mp4"
            a = 1

        if a == 1:
            self.path = "." + self.path
            f = open(self.path,'rb')
            self.send_header('Content-type', dataType)
            self.end_headers()
            self.wfile.write(f.read())
            f.close()

        return a
    #-------------------------------------------------

host = ''
port = 8010
httpd = HTTPServer((host, port), MyHandler)
print('serving at port', port)
httpd.serve_forever()






